jQuery(document).ready(function(){
  allOutlets = '';
  outletsByCity = '';

  jQuery.ajax({
    url: "https://coopervision.cloudwps.net/cvkr/locator/getarray.php",
    type: "post",
    dataType: "json",
    success: function(data){
      allOutlets = data;
      citylist = _.chain(allOutlets).map(function(s) { return s.city }).uniq().value();

      //construct option string
      optionstr = '<option value="" selected>All Region 1</option>';

      for (var i = 0; i < citylist.length; i++) {
        optionstr += ("<option value='" + citylist[i] + "' >" + citylist[i] + "</option>");
      }

      jQuery('#city').html(optionstr);
      
      populatehtml(data);
    },
    error: function(){
      alert('Error. Please try again.');
    }
  }); 

  //Select City
  jQuery('#city').change(function(){

    jQuery('#product').val('');

    //If Show All Selected
    if(jQuery('#city').val() == ''){
      outletsByCity = allOutlets;
      jQuery("#state").prop('disabled', true);
      jQuery('#state').val('');
      // jQuery('#gmap').attr('src','https://www.google.com/maps/embed/v1/place?key=AIzaSyAEzZuqnLP1hGhZRMh8GmY-vuXK-l1QJqY&q=taiwan');   
    }
    //Else
    else {
      outletsByCity = _.where(allOutlets, {city: jQuery('#city').val()});
      stateoption = _.chain(outletsByCity).map(function(s) { return s.state.replace(/\s+/g,'') }).uniq().value();
      jQuery("#state").prop('disabled', false);
      // jQuery('#gmap').attr('src','https://www.google.com/maps/embed/v1/place?key=AIzaSyAEzZuqnLP1hGhZRMh8GmY-vuXK-l1QJqY&q=' + jQuery('#city').val() + '"');  
    }

    //Construct Option Strings
    optionstr = '<option value="" selected>All Region 2</option>';
    for (var i = 0; i < stateoption.length; i++) {
      optionstr += ("<option value='" + stateoption[i] + "' >" + stateoption[i] + "</option>");
    }

    //Populate District Options
    jQuery('#state').html(optionstr);

    //Populate HTML
    // populatehtml(outletsByCity);
  });


  //Select District
  jQuery('#state').change(function(){

    jQuery('#product').val('');

    //If Show All Selected
    if(jQuery('#state').val() == ''){
      outletsByState = outletsByCity;
      // jQuery('#gmap').attr('src','https://www.google.com/maps/embed/v1/place?key=AIzaSyAEzZuqnLP1hGhZRMh8GmY-vuXK-l1QJqY&q=' + jQuery('#city').val() + '"');  
    }
    //Else
    else {
      outletsByState = _.where(outletsByCity, {state: jQuery('#state').val()});
      // jQuery('#gmap').attr('src','https://www.google.com/maps/embed/v1/place?key=AIzaSyAEzZuqnLP1hGhZRMh8GmY-vuXK-l1QJqY&q=' + jQuery('#city').val() + jQuery('#state').val() + '"');  
    }

    //Populate HTML
    // populatehtml(outletsByState);
  });

  // search function
  jQuery("#btnSearch").click(function() {
    var city = jQuery("#city").val();
    var state = jQuery("#state").val();
    var keyword = jQuery("#keyword").val();
    
    jQuery.ajax({
      url: "https://coopervision.cloudwps.net/cvkr/locator/getarray.php",
      type: "post",
      dataType: "json",
      data: { city: city, state: state, keyword: keyword },
      success: function(data){
        allOutlets = data;
        
        populatehtml(data);
      },
      error: function(xhr, status, error){
        var err = eval("(" + xhr.responseText + ")");
        alert(err.Message);
      }
    }); 
  });

});


//Populate HTML Function
function populatehtml(data){

  htmldata = '';

  var combined = _.partition(data, function (obj) {
    return obj.name.indexOf('寶島眼鏡') !== -1;
  });

  var formosa = '';

  var formosadata = combined[0];
  var restdata = combined[1];

  if(data != 0){

    // for (var i = 0; i < formosadata.length; i++) {
    //   url = 'https://www.google.com/maps/embed/v1/place?key=AIzaSyAEzZuqnLP1hGhZRMh8GmY-vuXK-l1QJqY&q=' + formosadata[i]['address1'] + '"';

    //   formosa+='<div class="outlet">';
    //   formosa+='<h4>'+ formosadata[i]['name'] +'</h4>';
    //   formosa+='<p>' + formosadata[i]['address1'] + '</p>';
    //   formosa+='<p><i class="fa fa-phone"></i> ' + formosadata[i]['phone'] + '</p>';
    //   formosa+='<p><i class="fa fa-search"></i> <a href="' + url + ' target="gmap">觀看地圖</a></p>'
    //   formosa+='</div>';
    // }

    for (var i = 0; i < restdata.length; i++) {
      // url = 'https://www.google.com/maps/embed/v1/place?key=AIzaSyAEzZuqnLP1hGhZRMh8GmY-vuXK-l1QJqY&q=' + restdata[i]['address1'] + '"';

      // htmldata+='<div class="outlet">';
      // htmldata+='<h4>'+ restdata[i]['name'] +'</h4>';
      // htmldata+='<p>' + restdata[i]['address1'] + '</p>';
      // htmldata+='<p><i class="fa fa-phone"></i> ' + restdata[i]['phone'] + '</p>';
      // htmldata+='<p><i class="fa fa-search"></i> <a href="' + url + ' target="gmap">觀看地圖</a></p>'
      // htmldata+='</div>';

      htmldata += '<tr>';
      htmldata += '<td class="text-center">'+ restdata[i]['name'] +'</td>';
      htmldata += '<td class="text-center">' + restdata[i]['address1'] + '</td>';
      htmldata += '<td class="text-center">' + restdata[i]['phone'] + '</td>';
      htmldata += '</tr>';
    }
  }
  else {
    htmldata += '<tr><td class="text-center" colspan="3">No results.</td></tr>';
  }

  // jQuery('#outletlist_formosa').html(formosa);
  // jQuery('#outletlist').html(htmldata);
  jQuery("#clinics tbody").empty();
  jQuery('#clinics tbody').append(htmldata);

  jQuery('.outlet p a').on("click",function(){
      $(window).scrollTop(0);
});

}