jQuery(document).ready(function(){
  allOutlets = '';
  outletsByCity = '';

  var citylist = [];
  var cliniclist = [];

  jQuery.ajax({
    url: "https://coopervision.cloudwps.net/cvkr/locator/getarray.php",
    type: "post",
    dataType: "json",
    data: { city: '', state: '', keyword: '' },
    success: function(data){
      cliniclist = data;
      // allOutlets = data;
      citylist = _.chain(cliniclist).map(function(s) { return s.city }).uniq().value();

      //construct option string
      optionstr = '<option value="" selected>도/시</option>';

      for (var i = 0; i < citylist.length; i++) {
        optionstr += ("<option value='" + citylist[i] + "' >" + citylist[i] + "</option>");
      }

      jQuery('#city').html(optionstr);
      
      populatehtml(data);
    },
    error: function(){
      alert('Error. Please try again.');
    }
  }); 

  //Select City
  jQuery('#city').change(function(){

    //If Show All Selected
    if(jQuery('#city').val() == ''){
      outletsByCity = cliniclist;
      jQuery("#state").prop('disabled', true);
      jQuery('#state').val('');
    } else {
      outletsByCity = _.where(cliniclist, {city: jQuery('#city').val()});
      stateoption = _.chain(outletsByCity).map(function(s) { return s.state.replace(/\s+/g,'') }).uniq().value();
      jQuery("#state").prop('disabled', false);
    }

    //Construct Option Strings
    optionstr = '<option value="" selected>구</option>';
    for (var i = 0; i < stateoption.length; i++) {
      optionstr += ("<option value='" + stateoption[i] + "' >" + stateoption[i] + "</option>");
    }

    //Populate District Options
    jQuery('#state').html(optionstr);

    //Populate HTML
    // populatehtml(outletsByCity);
  });


  //Select District
  jQuery('#state').change(function(){
    //If Show All Selected
    if(jQuery('#state').val() == ''){
      outletsByState = outletsByCity;
    } else {
      outletsByState = _.where(outletsByCity, {state: jQuery('#state').val()});
    }

    //Populate HTML
    // populatehtml(outletsByState);
  });

  // search function
  jQuery("#btnSearch").click(function() {
    search();
  });

  $("#keyword").keypress(function(event) {
    if (event.keyCode == 13) {
      search();
    }
  });

});



function search() {
  var city = jQuery("#city").val();
  var state = jQuery("#state").val();
  var keyword = jQuery("#keyword").val();

  jQuery('#clinics tbody').empty();
  jQuery("#clinics tbody").append('<tr><td class="text-center" colspan="3">Searching...</td></tr>');
  
  jQuery.ajax({
    url: "https://coopervision.cloudwps.net/cvkr/locator/getarray.php",
    type: "post",
    dataType: "json",
    data: { city: city, state: state, keyword: keyword },
    success: function(data){
      populatehtml(data);
    },
    error: function(xhr, status, error){
      var err = eval("(" + xhr.responseText + ")");
      alert(err.Message);
    }
  }); 
}


//Populate HTML Function
function populatehtml(data){

  htmldata = '';

  var combined = _.partition(data, function (obj) {
    return obj.name.indexOf('寶島眼鏡') !== -1;
  });

  var formosa = '';

  var formosadata = combined[0];
  var restdata = combined[1];

  jQuery('#clinics tbody').empty();

  if(data != 0){

    for (var i = 0; i < restdata.length; i++) {
      htmldata += '<tr>';
      htmldata += '<td class="text-center">'+ restdata[i]['name'] +'</td>';
      htmldata += '<td class="text-center">' + restdata[i]['address1'] + '</td>';
      htmldata += '<td class="text-center">' + restdata[i]['phone'] + '</td>';
      htmldata += '</tr>';
    }
    
    
    jQuery('#clinics tbody').append(htmldata);
  } else {
    jQuery('#clinics tbody').append('<tr><td class="text-center" colspan="3">Clinic not found.</td></tr>');
  }

  jQuery('.outlet p a').on("click",function(){
      $(window).scrollTop(0);
  });

}