jQuery(document).ready(function(){


  jQuery('#locator-filter br').remove();

  allOutlets = '';
  outletsByCity = '';

  jQuery.ajax({
    url: "https://coopervision.cloudwps.net/cvtw/locator/getarray.php",
    type: "post",
    dataType: "json",
    success: function(data){
      allOutlets = data;
      citylist = _.chain(allOutlets).map(function(s) { return s.city }).uniq().value();

      //construct option string
      optionstr = '<option value="showall" selected>下拉選取</option>';

      for (var i = 0; i < citylist.length; i++) {
        optionstr += ("<option value='" + citylist[i] + "' >" + citylist[i] + "</option>");
      }

      jQuery('#city').html(optionstr);
      
      populatehtml(data);
    },
    error: function(){
      alert('Error. Please try again.');
    }
  }); 

  //Select City
  jQuery('#city').change(function(){

    jQuery('#product').val('showall');

    //If Show All Selected
    if(jQuery('#city').val() == 'showall'){
      outletsByCity = allOutlets;
      jQuery("#state").prop('disabled', true);
      jQuery('#state').val('showall');
      jQuery('#gmap').attr('src','https://www.google.com/maps/embed/v1/place?key=AIzaSyAEzZuqnLP1hGhZRMh8GmY-vuXK-l1QJqY&q=taiwan');   
    }
    //Else
    else {
      outletsByCity = _.where(allOutlets, {city: jQuery('#city').val()});
      stateoption = _.chain(outletsByCity).map(function(s) { return s.state.replace(/\s+/g,'') }).uniq().value();
      jQuery("#state").prop('disabled', false);
      jQuery('#gmap').attr('src','https://www.google.com/maps/embed/v1/place?key=AIzaSyAEzZuqnLP1hGhZRMh8GmY-vuXK-l1QJqY&q=' + jQuery('#city').val() + '"');  
    }

    //Construct Option Strings
    optionstr = '<option value="showall" selected>下拉選取</option>';
    for (var i = 0; i < stateoption.length; i++) {
      optionstr += ("<option value='" + stateoption[i] + "' >" + stateoption[i] + "</option>");
    }

    //Populate District Options
    jQuery('#state').html(optionstr);

    //Populate HTML
    populatehtml(outletsByCity);
  });


  //Select District
  jQuery('#state').change(function(){

    jQuery('#product').val('showall');

    //If Show All Selected
    if(jQuery('#state').val() == 'showall'){
      outletsByState = outletsByCity;
      jQuery('#gmap').attr('src','https://www.google.com/maps/embed/v1/place?key=AIzaSyAEzZuqnLP1hGhZRMh8GmY-vuXK-l1QJqY&q=' + jQuery('#city').val() + '"');  
    }
    //Else
    else {
      outletsByState = _.where(outletsByCity, {state: jQuery('#state').val()});
      jQuery('#gmap').attr('src','https://www.google.com/maps/embed/v1/place?key=AIzaSyAEzZuqnLP1hGhZRMh8GmY-vuXK-l1QJqY&q=' + jQuery('#city').val() + jQuery('#state').val() + '"');  
    }

    //Populate HTML
    populatehtml(outletsByState);
  });


  //Select Product
  jQuery('#product').change(function(){

    var selectedProduct = jQuery('#product').val();

    if(jQuery('#product').val() == 'showall'){
        if(jQuery('#city').val() == 'showall'){
            outletsByProduct = allOutlets;
        }
        else if(jQuery('#state').val() == 'showall'){
            outletsByProduct = outletsByCity;
        }
        else{
            outletsByProduct = outletsByState;
        }
    }
    else{
        if(jQuery('#city').val() == 'showall'){
          outletsByProduct = _.where(allOutlets, {[selectedProduct]: '1'});
        }
        else if(jQuery('#state').val() == 'showall'){
          outletsByProduct = _.where(outletsByCity, {[selectedProduct]: '1'});
        }
        else{
          outletsByProduct = _.where(outletsByState, {[selectedProduct]: '1'});
        }
    }

    populatehtml(outletsByProduct);
  });

});


//Populate HTML Function
function populatehtml(data){

  htmldata = '';

  var combined = _.partition(data, function (obj) {
    return obj.name.indexOf('寶島眼鏡') !== -1;
  });

  var formosa = '';

  var formosadata = combined[0];
  var restdata = combined[1];

  if(data != 0){

    for (var i = 0; i < formosadata.length; i++) {
      url = 'https://www.google.com/maps/embed/v1/place?key=AIzaSyAEzZuqnLP1hGhZRMh8GmY-vuXK-l1QJqY&q=' + formosadata[i]['address1'] + '"';

      formosa+='<div class="outlet">';
      formosa+='<h4>'+ formosadata[i]['name'] +'</h4>';
      formosa+='<p>' + formosadata[i]['address1'] + '</p>';
      formosa+='<p><i class="fa fa-phone"></i> ' + formosadata[i]['phone'] + '</p>';
      formosa+='<p><i class="fa fa-search"></i> <a href="' + url + ' target="gmap">觀看地圖</a></p>'
      formosa+='</div>';
    }


    for (var i = 0; i < restdata.length; i++) {
      url = 'https://www.google.com/maps/embed/v1/place?key=AIzaSyAEzZuqnLP1hGhZRMh8GmY-vuXK-l1QJqY&q=' + restdata[i]['address1'] + '"';

      htmldata+='<div class="outlet">';
      htmldata+='<h4>'+ restdata[i]['name'] +'</h4>';
      htmldata+='<p>' + restdata[i]['address1'] + '</p>';
      htmldata+='<p><i class="fa fa-phone"></i> ' + restdata[i]['phone'] + '</p>';
      htmldata+='<p><i class="fa fa-search"></i> <a href="' + url + ' target="gmap">觀看地圖</a></p>'
      htmldata+='</div>';
    }
  }
  else {
    htmldata += '<h3>No results. Please select a different filter option.</h3>'
  }

  jQuery('#outletlist_formosa').html(formosa);
  jQuery('#outletlist').html(htmldata);

  jQuery('.outlet p a').on("click",function(){
      $(window).scrollTop(0);
});

}